<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<!--
		Image Scale Template

		Insert an image, scaled to maximal size. Aspect ratio is preserved.
-->
		
<xsl:template name="img-scale">
	<xsl:param name="img"/>
	<xsl:param name="max-width"/>
	<xsl:param name="max-height"/>
	<xsl:param name="force"/>
	
	<xsl:choose>
		<xsl:when test="$img/@width &lt;= 0 or $img/@height &lt;= 0">
			<!-- image size not known -->
			<img border="0">
				<xsl:attribute name="id"><xsl:value-of select="$img/@id"/></xsl:attribute>
				<xsl:attribute name="src"><xsl:value-of select="$img/@src"/></xsl:attribute>
				<xsl:attribute name="source"><xsl:value-of select="$img/@src"/></xsl:attribute>
				<!-- note: source is for Qt compatibility, especially with whitespace in file paths !! -->
				<xsl:if test="$force">
					<xsl:attribute name="width"><xsl:value-of select="$max-width"/></xsl:attribute>
					<xsl:attribute name="height"><xsl:value-of select="$max-height"/></xsl:attribute>
				</xsl:if>
			</img>
		</xsl:when>

		<xsl:otherwise>
			<!-- calculate image size - do keep aspect ratio -->
			<xsl:variable name="scalex" select="$max-width div $img/@width"/>
			<xsl:variable name="scaley" select="$max-height div $img/@height"/> 
			<xsl:variable name="scale">
					<xsl:choose>
						<xsl:when test="$scalex &lt; $scaley"><xsl:value-of select="$scalex"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$scaley"/></xsl:otherwise>
					</xsl:choose>
			</xsl:variable>

			<img border="0">
				<xsl:attribute name="id"><xsl:value-of select="$img/@id"/></xsl:attribute>
				<xsl:attribute name="src"><xsl:value-of select="$img/@src"/></xsl:attribute>
				<xsl:attribute name="source"><xsl:value-of select="$img/@src"/></xsl:attribute>
				<!-- note: source is for Qt compatibility, especially with whitespace in file paths !! -->
				<xsl:attribute name="width"><xsl:value-of select="$img/@width * $scale"/></xsl:attribute>
				<xsl:attribute name="height"><xsl:value-of select="$img/@height * $scale"/></xsl:attribute>
			</img>			
		</xsl:otherwise>
	</xsl:choose>
		
</xsl:template>

<!--
		Translation functions

		extract translated text from a Qt Linguist file (*.ts)
		three possible ways to call:
			(1)	function												mx:tr( 'Source Text' )
			(2)	function with additional context			mx:tr( 'Context', 'Source Text' )
			(3)	template (with or without context
							<xsl:call-template name="tr">
									<xsl:with-param name="context" select="Context"/>
									<xsl:with-param name="source"> Source Text </xsl:with-param>
-->

<xsl:variable name="translation-file"
	select="document(concat(string(/print/template-path), 'PrintTemplates_', string(/print/language), '.ts'))/TS"/>

<xsl:template name="tr">
	<xsl:param name="source"/>
	<xsl:param name="context" select="$translation-context"/>
	
	<xsl:variable name="translation"
		select="$translation-file/context[name=$context]/message[source=normalize-space($source)]/translation"/>
	
		<xsl:choose>
			<xsl:when test="$translation and string-length($translation) &gt; 0 "><xsl:value-of select="$translation"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$source"/></xsl:otherwise>
		</xsl:choose>	
</xsl:template>

<!-- 		XSL 2.0
			not supported by libxslt - bugger

<xsl:function name="mx:tr">	
	<xsl:param name="context"/>
	<xsl:param name="source"/>
	
	<xsl:call-template name="tr">
		<xsl:with-param name="context" select="$context"/>
		<xsl:with-param name="source" select="$source"/>
	</xsl:call-template>
</xsl:function>

<xsl:function name="mx:tr">
	<xsl:param name="source"/>
	
	<xsl:call-template name="tr">
		<xsl:with-param name="source" select="$source"/>
	</xsl:call-template>
</xsl:function>
-->

</xsl:transform>